IF OBJECT_ID('P_EST_NF_ENT_EXCLUSAO') IS NOT NULL
	BEGIN
		DROP PROCEDURE P_EST_NF_ENT_EXCLUSAO
	END
GO
-- P_EST_NF_ENT_EXCLUSAO 1,1,41
CREATE PROCEDURE P_EST_NF_ENT_EXCLUSAO (@CD_EMP INT, @CD_FILIAL INT, @CD_NF INT)
AS
begin
SET NOCOUNT ON 
DECLARE @CD_FILIAL_ORIGEM INT
DECLARE @CD_NF_ORIGEM INT
DECLARE @CD_PROD INT
DECLARE @QT_IT INT
DECLARE @CD_NT_MOV INT
DECLARE @CD_FORN INT
DECLARE @CD_PG_CRED INT=0
DECLARE @CD_DEB_FORN INT=0
DECLARE @NR_NF INT
DECLARE @DT_EMI_NF DATETIME
DECLARE @CD_FORN_VALID INT
DECLARE @ENTRADA_SNGPC INT=0
DECLARE @BAIXA_CONTAS_A_RECEBER INT=0


       SET @ENTRADA_SNGPC  =
          (SELECT               
           COUNT(A.CD_EMP)       
          FROM                 
             EST_SNGPC_ENTRADA (NOLOCK) A  
         
          WHERE 
            A.CD_EMP        =  @CD_EMP
            AND A.CD_FILIAL     = @CD_FILIAL
            AND A.CD_NF  = @CD_NF
          
          )
          
        IF(@ENTRADA_SNGPC > 0)
            BEGIN
                  RAISERROR('MOVIMENTAO NAO PODE SER EXCLUIDA JA FOI FEITO LANÇAMENTO DO SNGPC ', 16, 1);
				  RETURN;
            END;     

        SET @BAIXA_CONTAS_A_RECEBER  =
          (SELECT               
			A.STS_DP       
          FROM                 
             PG_CRED (NOLOCK) A  
			 JOIN PG_CRED_EST_NF_ENT B ON
			 A.CD_EMP = B.CD_EMP
			 AND A.CD_FILIAL = B.CD_FILIAL
			 AND A.NR_DP = B.NR_DP
         
          WHERE 
            B.CD_EMP        =  @CD_EMP
            AND B.CD_FILIAL     = @CD_FILIAL
            AND B.CD_NF  = @CD_NF
          
          )
          
        IF(@BAIXA_CONTAS_A_RECEBER IN (1,2))
            BEGIN
                  RAISERROR('MOVIMENTAO NAO PODE SER EXCLUIDA JA FOI FEITO BAIXA DO CONTAS A RECEBER ', 16, 1);
				  RETURN;
            END;   
		

print 'Buscando dados da nota fiscal de entrada filial.: ' + convert(varchar(5),@CD_FILIAL) + ' codigo(CD_NF).: ' + convert(varchar(5),@CD_NF)  + ' - Time : ' + convert(varchar,getdate(),108)
--Buscando dados da nota fiscal de entrada
SELECT
	@CD_FORN=CD_FORN,
	@NR_NF=NR_NF,
	@DT_EMI_NF=DT_EMI_NF
FROM
	EST_NF_ENT
WHERE
	CD_EMP =@CD_EMP
	AND CD_FILIAL=@CD_FILIAL
	AND CD_NF=@CD_NF


print 'Verificando se a nota fiscal possuir vinculo com nota de saida de transferencia.: ' + convert(varchar(5),@CD_FILIAL) + ' - Time : ' +convert(varchar,getdate(),108)
--Buscando dados da transferencia ou venda entre grupo
--Caso a nota fiscal de entrada seja oruinda desta transacao
SELECT
	@CD_FILIAL_ORIGEM=CD_FIL_ORIG,
	@CD_NF_ORIGEM=CD_NF_SAI
FROM
	EST_NF_ENT_EST_NF_SAI_TRANSF
where
	CD_EMP =@CD_EMP
	AND CD_FIL_DEST=@CD_FILIAL
	AND CD_NF_ENT=@CD_NF


IF @CD_NF_ORIGEM>0
begin
print 'Possui vinculo com transferencia, apaga o checkin de entrada dos produtos.: ' + convert(varchar(5),@CD_FILIAL) + ' - Time : ' +convert(varchar,getdate(),108)
--Deletando Checkin de entrada de nota fiscal de transferencia
DELETE FROM
	EST_NF_SAI_CHECKIN_ENTRADA_CPL_EST_PROD_CPL_LOTE
WHERE
	CD_EMP=@CD_EMP
	AND CD_FILIAL=@CD_FILIAL_ORIGEM
	AND CD_NF = @CD_NF_ORIGEM

DELETE FROM
	EST_NF_SAI_CHECKIN_ENTRADA_CPL
WHERE
	CD_EMP=@CD_EMP
	AND CD_FILIAL=@CD_FILIAL_ORIGEM
	AND CD_NF = @CD_NF_ORIGEM

DELETE FROM
	EST_NF_SAI_CHECKIN_ENTRADA
WHERE
	CD_EMP=@CD_EMP
	AND CD_FILIAL=@CD_FILIAL_ORIGEM
	AND CD_NF = @CD_NF_ORIGEM
--Fim

print 'Apagando vinculo com transferencia ' + convert(varchar(5),@CD_FILIAL) + ' - Time : ' +convert(varchar,getdate(),108)
--Deletando relacionamento com a transferencia
DELETE 
FROM 
	EST_NF_ENT_EST_NF_SAI_TRANSF 
WHERE
	CD_EMP = @CD_EMP
	AND CD_FIL_DEST = @CD_FILIAL
	AND CD_NF_ENT = @CD_NF
end

--Cancelando itens da nota fiscal e voltando o estoque se necessario
DECLARE CnotasEntradaItensCancel CURSOR FAST_FORWARD FOR 
SELECT
	i.CD_PROD,
	i.QT_IT,
	n.CD_NT_MOV
FROM
	EST_NF_ENT_IT i INNER JOIN EST_NF_ENT n ON
	i.CD_EMP = n.CD_EMP AND
	i.CD_FILIAL = n.CD_FILIAL AND
	i.CD_NF = n.CD_NF AND
	i.DT_ENT = n.DT_ENT
WHERE
	i.CD_EMP = @CD_EMP
	AND i.CD_FILIAL = @CD_FILIAL
	AND i.CD_NF = @CD_NF

--Deletando PG_DEB_FORN_EST_NF_ENT
SET @CD_DEB_FORN  =  (SELECT ISNULL(CD_DEB_FORN,0) FROM PG_DEB_FORN_EST_NF_ENT
WHERE
	CD_EMP = @CD_EMP
	AND CD_FILIAL = @CD_FILIAL
	AND CD_NF = @CD_NF	)

          
SET @CD_PG_CRED  = (SELECT ISNULL(CD_PG_CRED,0) FROM PG_DEB_FORN_PG_CRED
WHERE
	CD_EMP = @CD_EMP
	AND CD_FILIAL = @CD_FILIAL
	AND CD_DEB_FORN = @CD_DEB_FORN	)

DELETE
FROM PG_DEB_FORN_PG_CRED
WHERE
	CD_EMP = @CD_EMP
	AND CD_FILIAL = @CD_FILIAL
	AND CD_DEB_FORN = @CD_DEB_FORN

DELETE 
FROM PG_DEB_FORN
WHERE CD_EMP = @CD_EMP
AND CD_DEB_FORN = @CD_DEB_FORN


DELETE 
FROM PG_DEB_FORN_EST_NF_ENT
WHERE
	CD_EMP = @CD_EMP
	AND CD_FILIAL = @CD_FILIAL
	AND CD_NF = @CD_NF	

DELETE FROM PG_CRED_EST_NF_ENT
WHERE
	CD_EMP = @CD_EMP
	AND CD_FILIAL = @CD_FILIAL
	AND CD_NF = @CD_NF

DELETE 
FROM PG_CRED
WHERE CD_EMP = @CD_EMP
AND CD_FILIAL = @CD_FILIAL
AND CD_PG_CRED = @CD_PG_CRED

OPEN CnotasEntradaItensCancel
FETCH NEXT FROM CnotasEntradaItensCancel INTO @CD_PROD, @QT_IT,@CD_NT_MOV
	WHILE @@FETCH_STATUS=0
	  begin
	    
		EXEC P_EST_PROD_CPL_ESTOQUE_MOVIMENTACAO @CD_EMP, @CD_FILIAL,@CD_PROD, @CD_NT_MOV,@QT_IT,1

	  FETCH NEXT FROM CnotasEntradaItensCancel INTO  @CD_PROD, @QT_IT,@CD_NT_MOV
	end
PRINT 'Concluido.'
CLOSE CnotasEntradaItensCancel;
DEALLOCATE CnotasEntradaItensCancel;

print 'Apagando controle de lote de produtos.: ' + convert(varchar(5),@CD_FILIAL) + ' - Time : ' +convert(varchar,getdate(),108)
--Deletando itens da nota fiscal
DELETE 
FROM 
	 EST_NF_ENT_IT_EST_PROD_CPL_LOTE
WHERE
	CD_EMP = @CD_EMP
	AND CD_FILIAL = @CD_FILIAL
	AND CD_NF = @CD_NF


print 'Apagando checkin de produtos.: ' + convert(varchar(5),@CD_FILIAL) + ' - Time : ' +convert(varchar,getdate(),108)
--Deletando itens da nota fiscal
DELETE EST_NF_ENT_DANFE_PROVISORIO_CHECKIN_ENTRADA_CPL
WHERE
        CD_CTR = (SELECT
                      CD_CTR
                  FROM
                      EST_NF_ENT_DANFE_PROVISORIO
                  WHERE
                        CD_EMP = @CD_EMP
                    AND CD_FILIAL = @CD_FILIAL
                    AND @CD_FORN=CD_FORN 
					AND @NR_NF= NR_NF
					AND @DT_EMI_NF=DT_EMIS_NF)

print 'Apagando checkin Cabeçalho..: ' + convert(varchar(5),@CD_FILIAL) + ' - Time : ' +convert(varchar,getdate(),108)
DELETE EST_NF_ENT_DANFE_PROVISORIO_CHECKIN_ENTRADA
WHERE
        CD_CTR = (SELECT
                      CD_CTR
                  FROM
                      EST_NF_ENT_DANFE_PROVISORIO
                  WHERE
                        CD_EMP = @CD_EMP
                    AND CD_FILIAL = @CD_FILIAL
                    AND @CD_FORN=CD_FORN 
					AND @NR_NF= NR_NF
					AND @DT_EMI_NF=DT_EMIS_NF)

print 'Apagando vinculo com grupo economico ' + convert(varchar(5),@CD_FILIAL) + ' - Time : ' +convert(varchar,getdate(),108)
--Deletando itens da nota fiscal
DELETE 
FROM 
	EST_PROD_ENT_GRP_ECON_EST_NF_ENT_IT 
WHERE
	CD_EMP = @CD_EMP
	AND CD_FILIAL = @CD_FILIAL
	AND CD_NF = @CD_NF

print 'Apagando vinculo com pre-fatura ' + convert(varchar(5),@CD_FILIAL) + ' - Time : ' +convert(varchar,getdate(),108)
--Deletando itens da nota fiscal
DELETE 
FROM 
	EST_NF_ENT_EST_PED_VD 
WHERE
	CD_EMP = @CD_EMP
	AND CD_FILIAL = @CD_FILIAL
	AND CD_NF = @CD_NF

print 'Apagando vinculo com pedido compra ' + convert(varchar(5),@CD_FILIAL) + ' - Time : ' +convert(varchar,getdate(),108)
--Deletando itens da nota fiscal
DELETE 
FROM 
	EST_NF_ENT_PED_CP 
WHERE
	CD_EMP = @CD_EMP
	AND CD_FILIAL = @CD_FILIAL
	AND CD_NF = @CD_NF


print 'Apagando itens da nota fiscal ' + convert(varchar(5),@CD_FILIAL) + ' - Time : ' +convert(varchar,getdate(),108)
--Deletando itens da nota fiscal
DELETE 
FROM 
	EST_NF_ENT_IT 
WHERE
	CD_EMP = @CD_EMP
	AND CD_FILIAL = @CD_FILIAL
	AND CD_NF = @CD_NF

print 'Apagando vinculo com validacao da nota fiscal do fornecedor ' + convert(varchar(5),@CD_FILIAL) + ' - Time : ' +convert(varchar,getdate(),108)
--Verificando se a nota fiscal possui vinculo com 
--Validacao de notas de fornecedor
SELECT
	@CD_FORN_VALID=EST_NF_ENT_EST_NF_ENT_NFE_FORN_VALID.CD_CTR
FROM
	EST_NF_ENT_EST_NF_ENT_NFE_FORN_VALID
WHERE
    EST_NF_ENT_EST_NF_ENT_NFE_FORN_VALID.CD_NF=@CD_NF
	AND EST_NF_ENT_EST_NF_ENT_NFE_FORN_VALID.CD_EMP=@CD_EMP
    AND EST_NF_ENT_EST_NF_ENT_NFE_FORN_VALID.CD_FILIAL=@CD_FILIAL

IF @CD_FORN_VALID>0
begin    
    --Excluindo relacionamento
	DELETE 
	FROM
		EST_NF_ENT_EST_NF_ENT_NFE_FORN_VALID
	WHERE
		EST_NF_ENT_EST_NF_ENT_NFE_FORN_VALID.CD_CTR=@CD_FORN_VALID

    --Excluindo pendencia de validacao
	DELETE 
	FROM
		EST_NF_ENT_NFE_FORN_VALID_PENDENTE
	WHERE
		EST_NF_ENT_NFE_FORN_VALID_PENDENTE.CD_CTR=@CD_FORN_VALID

	DELETE 
	FROM
		EST_NF_ENT_NFE_FORN_VALID
	WHERE
		EST_NF_ENT_NFE_FORN_VALID.CD_CTR=@CD_FORN_VALID
end
else
begin
	DELETE
	FROM
		EST_NF_ENT_NFE_FORN_VALID
	WHERE
		CD_EMP =@CD_EMP
		AND CD_FILIAL=@CD_FILIAL
		AND CD_FORN=@CD_FORN
		AND NR_NF=@NR_NF
		AND DT_EMI_NF=@DT_EMI_NF
end

print 'Apagando EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_CONFIRMACAO_OPERACAO_PENDENTE ' + convert(varchar(5),@CD_FILIAL) + ' - Time : ' +convert(varchar,getdate(),108)

DELETE 
FROM 
	EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_CONFIRMACAO_OPERACAO_PENDENTE
WHERE
	CD_EMP = @CD_EMP
	AND CD_FILIAL = @CD_FILIAL
	AND CD_NF = @CD_NF
end



print 'Apagando nota fiscal de entrada ' + convert(varchar(5),@CD_FILIAL) + ' - Time : ' +convert(varchar,getdate(),108)

--Deletando relacionamento com a transferencia
DELETE 
FROM 
	EST_NF_ENT
WHERE
	CD_EMP = @CD_EMP
	AND CD_FILIAL = @CD_FILIAL
	AND CD_NF = @CD_NF



